#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>
using namespace std;

bool cmp(pair<long long int,long long int> prvi, pair<long long int,long long int> drugi)
{
    if(prvi.first>drugi.first) return true;
    return false;
}
struct Graph
{
    long long int n;
    vector<vector<long long int> > adj;
    vector<long long int> boja;

    vector<pair<long long int,long long int> > povezani;
    vector<long long int> moze_obojiti;
};

void init_graph(Graph &g,int n)
{
    g.n=n;
    g.adj.resize(n);
    g.boja.resize(n,0);

    for(long long int i=0;i<n;i++)
    {
        g.povezani.push_back(make_pair(0,i));
    }
    g.moze_obojiti.resize(n,0);
}

void addEdge(Graph &g,long long int u,long long int v)
{
    g.adj[u].push_back(v);
    g.adj[v].push_back(u);
    g.povezani[u].first++;
    g.povezani[v].first++;
    g.moze_obojiti[u]++;
    g.moze_obojiti[v]++;
}

void BFS(Graph &g)
{
    queue<long long int> q;
    queue<long long int> color;
    q.push(0);
    color.push(1);

    g.boja[0]=1;
    while(!q.empty())
    {
        long long int pom=q.front();
        long long int pomcol=color.front();
        q.pop();
        color.pop();
        for(long long int i=0;i<g.adj[pom].size();i++)
        {
            if(g.boja[g.adj[pom][i]]==0)
            {
               g.boja[g.adj[pom][i]]=pomcol*(-1);
               q.push(g.adj[pom][i]);
               color.push(pomcol*(-1));

            }

        }

    }



}
vector<long long int> crveni;
vector<long long int> plavi;

void Oboji(Graph &g)
{
    sort(g.povezani.begin(),g.povezani.end(),cmp);
    for(long long int i=0;i<g.n;i++)
    {
        if(g.moze_obojiti[g.povezani[i].second]>=2 || g.moze_obojiti[g.povezani[i].second]==g.povezani[i].first)
        {
            if(g.boja[g.povezani[i].second]==1)
            {
                crveni.push_back(g.povezani[i].second);
            }
            else
            {
                plavi.push_back(g.povezani[i].second);
            }
            for(long long int j=0;j<g.adj[g.povezani[i].second].size();j++)
            {
                g.moze_obojiti[g.adj[g.povezani[i].second][j]]--;
            }
        }
    }
}


int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    long long int n;
    cin >>n;
    vector<long long int> brojevi(n);
    for(long long int i=0;i<n;i++)
    {
        cin >>brojevi[i];
    }
    Graph g;
    init_graph(g,n);
    for(long long int i=0;i<n-1;i++)
    {
        long long int u,v;
        cin >>u>>v;
        u--;
        v--;
        addEdge(g,u,v);
    }
    BFS(g);
    //cout <<"ovde\n";
    Oboji(g);
    //cout <<"posle\n";
    cout <<(crveni.size()+plavi.size())*brojevi[0]<<"\n";
    cout <<crveni.size()<<"\n";
        for(long long int i=0;i<crveni.size();i++)
        {
            cout <<crveni[i]+1<<" ";
        }
        cout <<"\n";
        cout <<plavi.size()<<"\n";
        for(long long int i=0;i<plavi.size();i++)
        {
            cout <<plavi[i]+1<<" ";
        }
        cout <<"\n";




    return 0;
}